<?php

/**
 * Resolve file path relative to base URL.
 *
 * @param string $filePath The path to be resolved.
 * @return string Resolved file path or error message.
 */
function resolvePath($filePath)
{
    $basePath = $_SERVER['REQUEST_URI'] = '/smaiExpress'; // Set base path.
    $resolvedPath = $basePath . '/' . $filePath; // Combine base and file path.

    if (!file_exists($_SERVER['DOCUMENT_ROOT'] . $resolvedPath)) {
        $resolvedPath = resolvePath('config/fileNotFound.php');
    }

    return $resolvedPath; // Return resolved path.
}



/**
 * Resolve derived file paths that are generated from $_GET requests or related functions.
 *
 * @param string $filePath The derived path to be resolved.
 * @return string Resolved derived file path.
 */
function resolvePathBeta($filePath)
{
    $basePath = $_SERVER['REQUEST_URI'] = '/smaiExpress'; // Set base path.
    $resolvedPath = $basePath . '/' . $filePath; // Combine base and derived path.

    return $resolvedPath; // Return resolved derived path.
}
