<?php

/**
 * Dump and die function for debugging.
 *
 * @param mixed $value The value to be dumped.
 * @return void
 */
function dd($value)
{
    echo '<pre>';
    var_dump($value);
    echo '</pre>';

    die();
}

/**
 * Check if agent is logged in, redirect if not.
 *
 * @return void
 */
function check_login()
{
    if (!isset($_SESSION['loggedInAgent'])) {
        header("Location: " . resolvePath('app/views/auth/login.php'));  // Redirect to login.
        exit(); // Exit script
    }
}

/**
 * Check if admin is logged in, redirect if not.
 *
 * @return void
 */
function admin_login()
{
    if (!isset($_SESSION['loggedInAdmin'])) {
        header("Location: " . resolvePath('admin/app/views/auth/login.php'));  // Redirect to login.
        exit(); // Exit script
    }
}

/**
 * Generate random order ID starting with 99
 */
function generateOrderID()
{
    return 990000 + rand(0, 9999);
}


/**
 * Generate Unique User ID
 */
function generateUniqueID($length = 6)
{
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charLength = strlen($characters);
    $uniqueID = '';

    for ($i = 0; $i < $length; $i++) {
        $randomChar = $characters[rand(0, $charLength - 1)];
        $uniqueID .= $randomChar;
    }

    return $uniqueID;
}


/**
 * Covert timestamp to calendar format
 */
function convertTimeFormat($time)
{
    $formattedTime = date('d/m/Y', strtotime($time));
    return $formattedTime;
}
function convertTimeFormatBeta($time)
{
    $formattedTime = date('Y-m-d', strtotime($time));
    return $formattedTime;
}
/**
 * Format Price
 */
function formatPrice($number)
{
    return number_format($number, 2, '.', ',');
}

/**
 * Create a reusable SMS function
 */
function sendSMSAPI($contact, $message)
{

    $curl = curl_init();

    $json_data = json_encode([
        "from" => "CARGO",
        "to" => $contact,
        "text" => $message,
        "reference" => "aswqetgcv"
    ]);

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://messaging-service.co.tz/api/sms/v1/text/single',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $json_data,
        CURLOPT_HTTPHEADER => array(
            'Authorization: Basic UGF0cmlja3RoZW9sOmluYnVzc25lc3M=',
            'Content-Type: application/json',
            'Accept: application/json'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
}


/**
 * Function to send sms to sender
 */
function senderSMS($sender, $cargoID, $cargoDestination, $senderNo)
{
    $contact = "$senderNo";
    $message = 'Habari ' . $sender . ', Mzigo wako umepokelewa kwenye warehouse yetu tayari kwa kusafirishwa kwenda ' . $cargoDestination . '. Namba ya mzigo wako ni ' . $cargoID . '. Asante kwa kusafirisha nasi';

    sendSMSAPI($contact, $message);
}

/**
 * Function to send sms to reciever
 */
function recieverSMS($reciever, $cargoID, $cargoLocatoin, $recieverNo)
{
    $contact = "$recieverNo";
    $message = 'Habari ' . $reciever . ', Tunapenda kukujulisha kua mzigo wenye namba ' . $cargoID . ' unatumwa kwako kutokea ' . $cargoLocatoin . ' . Tutakujulisha mzigo ufikapo kwenye warehouse yetu iliyopo karibu nawe. Asante';

    sendSMSAPI($contact, $message);
}

/**
 * Function to update reciever package arrived
 */
function deliveredSMS($reciever, $cargoID, $recieverNo)
{
    $contact = "$recieverNo";
    $message = 'Habari ' . $reciever . ', Mzigo wako wenye namba ' . $cargoID . ' umefika! Tafadhali fika kituoni kwetu kuuchukua mzigo wako. Karibu tukuhudumie';

    sendSMSAPI($contact, $message);
}


/**
 * Function to set active page
 */
function setActive($pageName)
{
    $current_page = basename($_SERVER['PHP_SELF']);
    if ($current_page === $pageName) {
        return 'text-gray-800 dark:text-gray-100"';
    }
}

function setActiveBar($pageName)
{
    $current_page = basename($_SERVER['PHP_SELF']);
    if ($current_page === $pageName) {
        echo 'class = "absolute inset-y-0 left-0 w-1 bg-purple-600 rounded-tr-lg rounded-br-lg"';
    }
}

function setActiveBarAdmin($pageName)
{
    $current_page = basename($_SERVER['PHP_SELF']);
    if ($current_page === $pageName) {
        echo 'class="absolute inset-y-0 left-0 w-1 bg-red-600 rounded-tr-lg rounded-br-lg"';
    }
}

function truncateString($inputString)
{
    // Check if the input string is longer than 12 characters
    if (strlen($inputString) > 9) {
        // Truncate the string to the first 12 characters
        $truncatedString = substr($inputString, 0, 9);
        return $truncatedString . "...";
    } else {
        // If the input string is already 12 characters or shorter, return it as is
        return $inputString;
    }
}

function formatTanzaniaPhoneNumber($phoneNumber)
{
    // Remove any non-digit characters from the phone number
    $phoneNumber = preg_replace('/\D/', '', $phoneNumber);

    // Check if the phone number starts with '255' (international format)
    if (substr($phoneNumber, 0, 3) === '255') {
        // Remove the '255' prefix
        $phoneNumber = substr($phoneNumber, 3);
    }

    // Check if the phone number starts with '0' (local format)
    if (substr($phoneNumber, 0, 1) !== '0') {
        // Add a '0' prefix
        $phoneNumber = '0' . $phoneNumber;
    }

    return $phoneNumber;
}

function formatTanzaniaPhoneNumber255($var) {
    // Remove any non-digit characters from the phone number
    $phoneNumber = preg_replace('/\D/', '', $var);

    // Check if the phone number starts with '0' (local format)
    if (substr($phoneNumber, 0, 1) === '0') {
        // Remove the '0' prefix
        $phoneNumber = substr($phoneNumber, 1);
    }

    // Check if the phone number starts with '255' (international format)
    if (substr($phoneNumber, 0, 3) !== '255') {
        // Add the '255' prefix
        $phoneNumber = '255' . $phoneNumber;
    }

    return $phoneNumber;
}


/**
 * Send Email to admin after package is payed
 */
function sendPaymentEmail($agentName, $payedAmount, $paymentMethod)
{
    $to      = 'info@smai.co.tz, sudi@smai.co.tz';

    $subject = 'Payment Confirmation';

    $message = "Hello Smai Admin, This is a confirmation that agent $agentName has received payment of $payedAmount through $paymentMethod.
    Please confirm this Transaction";

    $headers = 'From: admin@smai.co.tz' . "\r\n" .

        'Reply-To: admin@smai.co.tz' . "\r\n" .

        'X-Mailer: PHP/' . phpversion();

    if (mail($to, $subject, $message, $headers)) {
        // echo "Success";
    } else {
        echo "Failed to send email";
    }
}
