<?php include("framework/init.php"); ?>

<body>
  <div class="flex h-screen bg-gray-50 dark:bg-gray-900" :class="{ 'overflow-hidden': isSideMenuOpen }">
    <?php include("framework/nav.php"); ?>

    <div class="flex flex-col flex-1 w-full">
      <?php include("framework/header.php"); ?>

      <!-- Main content -->
      <main class="h-full pb-16 overflow-y-auto">
        <div class="container px-6 mx-auto grid">
          <h4 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
            Add Package
          </h4>
          <div class="px-4 py-3 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
            <form action="" method="POST">
              <label class="block text-sm">
                <span class="text-gray-700 dark:text-gray-400">Destintion</span>
                <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="eg. Laptop Pack" name="PackageName" required />
              </label>
              <br>
              <label class="block text-sm">
                <span class="text-gray-700 dark:text-gray-400">Sender Info</span>
                <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="eg. Jane Doe" name="SenderName" required />
                <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="eg. 255655334422" name="SenderContactInfo" value="255" required />
              </label>
              <br>
              <label class="block text-sm">
                <span class="text-gray-700 dark:text-gray-400">Reciever Info</span>
                <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="eg. Jane Doe" name="ReceiverName" required />
                <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="eg. 255655334422" name="ReceiverContactInfo" value="255" required />
              </label>

              <div class="mt-4 text-sm">
                <span class="text-gray-700 dark:text-gray-400">
                  Package Type
                </span>
                <div class="mt-2">
                  <label class="inline-flex items-center text-gray-600 dark:text-gray-400">
                    <input type="radio" class="text-purple-600 form-radio focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" name="accountType" value="personal" onclick="text_show(0)" />
                    <span class="ml-2">Personal</span>
                  </label>
                  <label class="inline-flex items-center ml-6 text-gray-600 dark:text-gray-400">
                    <input type="radio" class="text-purple-600 form-radio focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" name="accountType" value="busines" onclick="text_show(1)" />
                    <span class="ml-2">Business</span>
                  </label>
                </div>
              </div>

              <!-- if condition -->
              <br>
              <div id="vendorNameField" class="w-full hidden">
                <label class="block text-sm">
                  <span class="text-gray-700 dark:text-gray-400">Vendor Name</span>
                  <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="Enter Vendor Name" name="VendorName" />
                </label>
              </div>

              <label class="block text-sm">
                <span class="text-gray-700 dark:text-gray-400">Destintion</span>
                <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="Enter Destination" name="Destination" required />
              </label>
              <br>
              <label class="block text-sm">
                <span class="text-gray-700 dark:text-gray-400">Ship Way</span>
                <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="Eg. Road" name="Shipway" required />
              </label>
              <br>
              <label class="block text-sm">
                <span class="text-gray-700 dark:text-gray-400">Thamani Ya Mzigo</span>
                <div class="relative text-gray-500 focus-within:text-purple-600 dark:focus-within:text-purple-400">
                  <input class="block w-full pl-10 mt-1 text-sm text-black dark:text-gray-300 dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray form-input" placeholder=" Eg. 20000" name="PackageValue" type="number" step="0.01" min="0" required />
                  <div class="absolute inset-y-0 flex items-center ml-3 pointer-events-none">
                    Tsh:
                  </div>
                </div>
              </label>
              <div class="mt-4 text-sm">
                <span class="text-gray-700 dark:text-gray-400">
                  Payment Status
                </span>
                <div class="mt-2">
                  <label class="inline-flex items-center text-gray-600 dark:text-gray-400">
                    <input type="radio" class="text-purple-600 form-radio focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" name="PaymentStatus" value="PAID" onclick="payment_status(0)" />
                    <span class="ml-2">PAID</span>
                  </label>
                  <label class="inline-flex items-center ml-6 text-gray-600 dark:text-gray-400">
                    <input type="radio" class="text-purple-600 form-radio focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" name="PaymentStatus" value="UNPAID" onclick="payment_status(1)" />
                    <span class="ml-2">UNPAID</span>
                  </label>
                </div>
              </div>

              <br>
              <label class="block text-sm">
                <span class="text-gray-700 dark:text-gray-400">Shipping Fee</span>
                <div class="relative text-gray-500 focus-within:text-purple-600 dark:focus-within:text-purple-400">
                  <input class="block w-full pl-10 mt-1 text-sm text-black dark:text-gray-300 dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray form-input" type="number" step="0.01" min="0" placeholder="" name="ShippingFee" />
                  <div class="absolute inset-y-0 flex items-center ml-3 pointer-events-none">
                    Tsh:
                  </div>
                </div>
              </label>
              <!-- if condition -->
              <br>
              <div id="paymentFields" class="hidden">
                <span class="text-gray-700 dark:text-gray-400">
                  Payment Method
                </span>
                <div class="mt-2 text-sm">
                  <label class="inline-flex items-center text-gray-600 dark:text-gray-400">
                    <input type="radio" class="text-purple-600 form-radio focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" name="PaymentChannel" value="BANK" onclick="payment_method(0)" />
                    <span class="ml-2">BANK</span>
                  </label>
                  <label class="inline-flex items-center ml-6  text-gray-600 dark:text-gray-400">
                    <input type="radio" class="text-purple-600 form-radio focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" name="PaymentChannel" value="CASH" onclick="payment_method(1)" />
                    <span class="ml-2">CASH</span>
                  </label>
                </div>
                <br>
                <label id="transaction_id" class="text-sm hidden">
                  <span class="text-gray-700 dark:text-gray-400">Transaction ID</span>
                  <input class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="Enter Transaction Id" name="TransactionID" />
                </label>
              </div>
              <br>
              <label class="block mt-4 text-sm">
                <span class="text-gray-700 dark:text-gray-400">Package Description</span>
                <textarea class="block w-full mt-1 text-sm dark:text-gray-300 dark:border-gray-600 dark:bg-gray-700 form-textarea focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray" rows="3" placeholder="Enter some long form content." name="PackageDescriptoin"></textarea>
              </label>
              <br>
              <button class="px-3 py-1 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-md active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple" name="AddPackage" type="submit">
                Submit
              </button>
            </form>
          </div>
        </div>
      </main>
      <!-- End of main body -->

    </div>
  </div>
</body>

<script>
  function text_show(x) {
    var element = document.getElementById("vendorNameField");
    if (x == 0) {
      element.classList.remove("block");
      element.classList.add("hidden");
    } else {
      element.classList.add("block");
      element.classList.remove("hidden");
    }
  }

  function payment_status(x) {
    var element = document.getElementById("paymentFields");
    if (x == 1) {
      element.classList.remove("block");
      element.classList.add("hidden");
    } else {
      element.classList.add("block");
      element.classList.remove("hidden");
    }
  }

  function payment_method(x) {
    var letsGet = document.getElementById("transaction_id");
    if (x == 1) {
      letsGet.classList.remove("block");
      letsGet.classList.add("hidden");
    } else {
      letsGet.classList.add("block");
      letsGet.classList.remove("hidden");
    }
  }
</script>