<?php
// require_once '../../../config/routes.php';
$receivedJSON = $_POST['jsonData'];

// Check if data was received
if ($receivedJSON !== null) {
    $postData = json_decode($receivedJSON, true);

    if ($postData !== null) {
        // Data successfully decoded
        $Id = $postData["Id"];
        $PackageID = $postData["PackageID"];
        $PackageName = $postData["PackageName"];
        $PackageDescription = $postData["PackageDescriptoin"]; // Note the typo in your original data
        $DepartureLocation = $postData["DepartureLocation"];
        $Destination = $postData["Destination"];
        $SenderName = $postData["SenderName"];
        $SenderContactInfo = $postData["SenderContactInfo"];
        $ReceiverName = $postData["ReceiverName"];
        $ReceiverContactInfo = $postData["ReceiverContactInfo"];
        $RecordingAgentID = $postData["RecordingAgentID"];
        $Status = $postData["Status"];
        $ShippingFee = $postData["ShippingFee"];
        $ShippingFee = number_format($ShippingFee, 2, '.', ',');
        $date = $postData["date"];
        $today = date('jS M Y', strtotime('today'));
        $date= date('d/m/Y', strtotime($date));
    } else {
        echo "Error decoding JSON data.";
    }
} else {
    echo "No data received.";
}

ob_end_clean();
require('fpdf/fpdf.php');

// Instantiate and use the FPDF class
$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AddPage();

/* Set font to arial, bold, 14pt */
$pdf->SetFont('Arial', 'B', 10);

/* Cell(width, height, text, border, end line, [align]) */
$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(71, 5, 'DELIVERED TO', 0, 0);
$pdf->Cell(59, 5, '', 0, 0);
$pdf->Cell(59, 5, 'SHIPPED BY:' . $Status, 0, 1);

$pdf->SetFont('Arial', '', 14);

$pdf->Cell(130, 5, 'Name: ' . $SenderName, 0, 0);
$pdf->Cell(25, 5, '', 0, 0);
$pdf->Cell(34, 5, '', 0, 1);

$pdf->Cell(130, 5, 'Destination: ' . $DepartureLocation, 0, 0);
$pdf->Cell(25, 5, 'Date Issued:'.$PackageID, 0, 0);
$pdf->Cell(34, 5, $today, 0, 1);
$pdf->Cell(130, 5, 'Phone No: ' . $SenderContactInfo, 0, 1);

$pdf->Cell(130, 5, '', 0, 0);
$pdf->Cell(25, 5, 'Receipt No:', 0, 0);
$pdf->Cell(34, 5, 'ORD001', 0, 1);
$pdf->Cell(34, 5, 'Phone', 0, 1);
//new box
$pdf->Rect(10, 60, 95, 20); // Adjust the coordinates and dimensions as needed
$pdf->Rect(105, 60, 95, 20); // Adjust the coordinates and dimensions as needed
$pdf->Line(105, 60, 105, 80); // Draw a vertical line to divide the two rectangles

// Add dummy data to the first box
$pdf->SetFont('Arial', '', 16);
$pdf->SetXY(10, 60);
$pdf->Cell(47.5, 10, 'ODER ID:', 0, 0, 'C');

// Add dummy data to the second box
$pdf->SetXY(105, 60);
$pdf->Cell(47.5, 10, 'Payment type', 0, 0, 'C');



$pdf->Ln(15); // Add a 1 cm (10 mm) vertical space

// Move the table drawing and dummy data inside the header
// Draw a horizontal table divided in half by two vertical lines
$pdf->Rect(10, 60, 95, 20); // Adjust the coordinates and dimensions as needed
$pdf->Rect(105, 60, 95, 20); // Adjust the coordinates and dimensions as needed
$pdf->Line(20.5, 60, 20.5, 80); // Draw the first vertical line to divide the first rectangle
$pdf->Line(105, 80, 105, 80); // Draw the second vertical line to divide the two rectangles
$pdf->Line(157.5, 60, 157.5, 80); // Draw the third vertical line to divide the second rectangle

// Draw three horizontal lines
$pdf->Line(10, 70, 200, 70);
$pdf->Line(15, 80, 200, 80);
$pdf->Line(10, 90, 200, 90);

// Add dummy data to the first box
$pdf->SetFont('Arial', '', 16);
$pdf->SetXY(10, 60);
$pdf->Cell(47.5, 10, 'ODER ID:', 0, 0, 'C');

// Add dummy data to the second box
$pdf->SetXY(105, 60);
$pdf->Cell(47.5, 10, 'Payment type', 0, 0, 'C');

// Add dummy data to the second box
$pdf->SetXY(157, 60);
$pdf->Cell(47.5, 10, 'Price', 0, 0, 'C');

// Add dummy data to the third box
$pdf->SetXY(20.5, 70);
$pdf->Cell(84.5, 10, 'Cash on delivery', 0, 0, 'C');

// Add dummy data to the fourth box
$pdf->SetXY(105, 70);
$pdf->Cell(47.5, 10, 'Data 2', 0, 0, 'C');

// Add dummy data to the fifth box
$pdf->SetXY(157.5, 70);
$pdf->Cell(42.5, 10, '10,000', 0, 0, 'C');

// Add dummy data to the sixth box
$pdf->SetXY(10, 80);
$pdf->Cell(47.5, 10, '', 0, 0, 'C');

// Add dummy data to the seventh box
$pdf->SetXY(105, 80);
$pdf->Cell(47.5, 10, 'Total', 0, 0, 'C');

// Add dummy data to the eighth box
$pdf->SetXY(157.5, 80);
$pdf->Cell(42.5, 10, '10,000', 0, 0, 'C');


$pdf->Output();
