<main class="h-full overflow-y-auto">
    
    <div class="container px-6 mx-auto grid">
        <div id="excelUploadForm" class="hidden">
            <form action="" method="POST" enctype="multipart/form-data">
                <div class="mb-3">
                    <label for="formFile" class="mb-2 inline-block text-neutral-700 dark:text-neutral-200 w-full">Choose Excel File (.xlsx)</label>
                    <span class="flex justify-between">
                        <input type="file" accept=".xlsx, .xls" name="fileToUpload" id="formFile" class="border border-solid border-neutral-300 file:-mx-3 file:-my-[0.32rem] file:overflow-hidden file:rounded-none file:border-0 file:border-solid file:border-inherit file:bg-neutral-100 file:px-3 file:py-[0.32rem] file:text-neutral-700 file:transition file:duration-150 file:ease-in-out file:[border-inline-end-width:1px] file:[margin-inline-end:0.75rem] hover:file:bg-neutral-200 focus:border-primary focus:text-neutral-700 focus:shadow-te-primary focus:outline-none dark:border-neutral-600 dark:text-neutral-200 dark:file:bg-neutral-700 dark:file:text-neutral-100 dark:focus:border-primary" />
                        <button class="bg-blue-500 text-white font-semibold text-sm py-1 px-2" onclick="closeForm()" type="submit" name="uploadExcelFile">Submit</button>
                    </span>
                </div>
            </form>
        </div>
        <div class="custom_devider">
            <div class="custom_devider_header">
                <h2 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
                    All Packages
                </h2>
            </div>
            <div class="custom_devider_button">
                <div class="px-6 my-6">
                    <button onclick="showForm()" id="uploadExcel" class="flex items-center justify-between w-full px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
                        Import Excel
                        <span class="ml-2" aria-hidden="true">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-filetype-xlsx" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M14 4.5V11h-1V4.5h-2A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v9H2V2a2 2 0 0 1 2-2h5.5L14 4.5ZM7.86 14.841a1.13 1.13 0 0 0 .401.823c.13.108.29.192.479.252.19.061.411.091.665.091.338 0 .624-.053.858-.158.237-.105.416-.252.54-.44a1.17 1.17 0 0 0 .187-.656c0-.224-.045-.41-.135-.56a1.002 1.002 0 0 0-.375-.357 2.028 2.028 0 0 0-.565-.21l-.621-.144a.97.97 0 0 1-.405-.176.37.37 0 0 1-.143-.299c0-.156.061-.284.184-.384.125-.101.296-.152.513-.152.143 0 .266.023.37.068a.624.624 0 0 1 .245.181.56.56 0 0 1 .12.258h.75a1.093 1.093 0 0 0-.199-.566 1.21 1.21 0 0 0-.5-.41 1.813 1.813 0 0 0-.78-.152c-.293 0-.552.05-.777.15-.224.099-.4.24-.527.421-.127.182-.19.395-.19.639 0 .201.04.376.123.524.082.149.199.27.351.367.153.095.332.167.54.213l.618.144c.207.049.36.113.462.193a.387.387 0 0 1 .153.326.512.512 0 0 1-.085.29.558.558 0 0 1-.255.193c-.111.047-.25.07-.413.07-.117 0-.224-.013-.32-.04a.837.837 0 0 1-.249-.115.578.578 0 0 1-.255-.384h-.764Zm-3.726-2.909h.893l-1.274 2.007 1.254 1.992h-.908l-.85-1.415h-.035l-.853 1.415H1.5l1.24-2.016-1.228-1.983h.931l.832 1.438h.036l.823-1.438Zm1.923 3.325h1.697v.674H5.266v-3.999h.791v3.325Zm7.636-3.325h.893l-1.274 2.007 1.254 1.992h-.908l-.85-1.415h-.035l-.853 1.415h-.861l1.24-2.016-1.228-1.983h.931l.832 1.438h.036l.823-1.438Z" />
                            </svg>
                        </span>
                    </button>
                </div>
            </div>
        </div>

        <script>
            function showForm() {
                document.getElementById("excelUploadForm").className = "bg-white p-3 text-black w-1/3 max-w-sm mx-auto rounded-xl shadow-lg space-y-2 sm:py-4 sm:flex sm:items-center sm:space-y-0 sm:space-x-6";
            }

            function closeForm() {
                document.getElementById("excelUploadForm").className = "hidden";
            }
        </script>

        <!-- New Table -->
        <div class="w-full overflow-hidden rounded-lg shadow-xs">
            <div class="w-full overflow-x-auto">
                <form action="" method="POST">
                    <table class="w-full whitespace-no-wrap">
                        <thead>
                            <tr class="text-gray-700 dark:text-gray-400">
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <label for="select-all">
                                        <input type="button" id="select-all" onclick='selects()' value="" class="w-[1.125rem] h-[1.125rem] text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" />
                                        Select All
                                    </label>
                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <label for="deselect-all">
                                        <input type="button" id="deselect-all" value="" onclick='deSelect()' class="w-[1.125rem] h-[1.125rem] text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" />
                                        Unselect All
                                    </label>
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">

                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <span class="flex">
                                        <!-- Open the modal using ID.showModal() method -->
                                        <dialog id="my_modal_edit" class="modal rounded-md bg-green-50 dark:bg-gray-100 ">
                                            <div class="modal-box">
                                                <h3 class="font-bold text-lg">Edit Model</h3>
                                                <p class="py-4">Press ESC key or click the button below to close</p>
                                                <div class="modal-action">
                                                    <!-- if there is a button in form, it will close the modal -->
                                                    <div class="text-gray-700">
                                                        <h3>Update Status for selected items</h3>
                                                        <select name="status" class="block w-full mt-1 text-sm  form-select focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray">
                                                            <option id="fuggy-package-id"></option>
                                                            <option value="Received">Received</option>
                                                            <option value="In Transit">In Transit</option>
                                                            <option value="Delivered">Delivered</option> 
                                                            <option value="Cleared">Cleared</option>
                                                        </select>
                                                    </div>
                                                    <br>
                                                    <div class="flex justify-between">
                                                        <button type="submit" name="admin_submit_action" value="Edit" class="btn py-1 px-3 text-green-500 bg-green-100 rounded-sm border-2 border-gray-600 dark:text-green-100 dark:bg-green-500 font-semibold focus:outline-none">Submit</button>
                                                        <form method="dialog">
                                                            <button class="btn">Close</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </dialog>
                                        <button type="button" onclick="my_modal_edit.showModal()" class="mr-3 focus:outline-none focus:border-transparent">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z" />
                                            </svg>
                                        </button>
                                        Edit
                                    </span>
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">

                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <span class="flex">
                                        <!-- Open the modal using ID.showModal() method -->
                                        <dialog id="my_modal_delete" class="modal rounded-md bg-green-50 dark:bg-gray-100 ">
                                            <div class="modal-box">
                                                <h3 class="font-bold text-lg">Delete Packages</h3>

                                                <p class="py-4">Are you sure you want to delete selected packages?</p>
                                                <div class="modal-action">
                                                    <!-- if there is a button in form, it will close the modal -->
                                                    <div class="flex justify-between">
                                                        <button type="submit" name="admin_submit_action" value="Delete" class="btn py-1 px-3 text-orange-500 bg-orange-100 rounded-sm border border-gray-600 dark:text-orange-100 dark:bg-orange-500 font-semibold focus:outline-none">Delete</button>
                                                        <form method="dialog">
                                                            <button class="btn">Close</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </dialog>
                                        <button type="button" onclick="my_modal_delete.showModal()" class="btn mr-3 focus:outline-none focus:border-transparent">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                            </svg>
                                        </button>
                                        Delete
                                    </span>
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">

                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <span class="flex">
                                        <dialog id="my_modal_export" class="modal rounded-md bg-green-50 dark:bg-gray-100 ">
                                            <div class="modal-box">
                                                <h3 class="font-bold text-lg">Export Model</h3>
                                                <p class="py-4">Press ESC key or click the button below to close</p>
                                                <div class="modal-action">
                                                    <!-- <form method="dialog"> -->
                                                    <!-- if there is a button in form, it will close the modal -->
                                                    <!-- <button class="btn">Close</button> -->
                                                    <!-- </form> -->
                                                    <!-- onclick="my_modal_export.showModal()"  -->
                                                </div>
                                            </div>
                                        </dialog>
                                        <button type="submit" name="admin_submit_action" value="Export" class="mr-3 focus:outline-none focus:border-transparent">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-spreadsheet" viewBox="0 0 16 16">
                                                <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zM9.5 3A1.5 1.5 0 0 0 11 4.5h2V9H3V2a1 1 0 0 1 1-1h5.5v2zM3 12v-2h2v2H3zm0 1h2v2H4a1 1 0 0 1-1-1v-1zm3 2v-2h3v2H6zm4 0v-2h3v1a1 1 0 0 1-1 1h-2zm3-3h-3v-2h3v2zm-7 0v-2h3v2H6z" />
                                            </svg>
                                        </button>
                                        Export
                                    </span>
                                </td>
                            </tr>
                            <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                                <th class="px-4 py-3">Package Info</th>
                                <th class="px-4 py-3">Payment</th>
                                <th class="px-4 py-3">Location</th>
                                <th class="px-4 py-3">Destination</th>
                                <th class="px-4 py-3">Sender</th> 
                                <th class="px-4 py-3">Reciever</th>
                                <th class="px-4 py-3">Date</th>
                                <th class="px-4 py-3">Status</th>
                                <th class="px-4 py-3">Action</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                        <?= renderFilteredPackages($packages, "Cleared") ?>
                        </tbody>
                    </table>
                </form>
            </div>
            <div class="grid px-4 py-3 text-xs font-semibold tracking-wide text-gray-500 uppercase border-t dark:border-gray-700 bg-gray-50 sm:grid-cols-9 dark:text-gray-400 dark:bg-gray-800">
                <span class="flex items-center col-span-3">
                    Showing 21-30 of 100
                </span>
                <span class="col-span-2"></span>
                <!-- Pagination -->
                <span class="flex col-span-4 mt-2 sm:mt-auto sm:justify-end">
                    <nav aria-label="Table navigation">
                        <ul class="inline-flex items-center">
                            <li>
                                <button class="px-3 py-1 rounded-md rounded-l-lg focus:outline-none focus:shadow-outline-purple" aria-label="Previous">
                                    <svg aria-hidden="true" class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" fill-rule="evenodd"></path>
                                    </svg>
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 text-white transition-colors duration-150 bg-purple-600 border border-r-0 border-purple-600 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    1
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    2
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    3
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    4
                                </button>
                            </li>
                            <li>
                                <span class="px-3 py-1">...</span>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    8
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    9
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md rounded-r-lg focus:outline-none focus:shadow-outline-purple" aria-label="Next">
                                    <svg class="w-4 h-4 fill-current" aria-hidden="true" viewBox="0 0 20 20">
                                        <path d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" fill-rule="evenodd"></path>
                                    </svg>
                                </button>
                            </li>
                        </ul>
                    </nav>
                </span>
            </div>
        </div><br>

    </div>
</main>