<main class="h-full overflow-y-auto">
    <div class="container px-6 mx-auto grid">
        <div class="custom_devider">
            <div class="custom_devider_header">
                <h2 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
                    Admin Dashboard
                </h2>
            </div>
            <div class="custom_devider_button">
                <div class="px-6 my-6">
                    <a class="flex items-center justify-between w-full px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple" href="<?= resolvePath('admin/app/views/createagent.php') ?>">
                        Add Agent 
                        <span class="ml-2" aria-hidden="true">+</span>
                    </a>
                </div>
            </div>
        </div>
        <!-- CTA -->
        <a class="flex items-center justify-between p-4 mb-8 text-sm font-semibold text-orange-500 bg-orange-100 rounded-lg shadow-md focus:outline-none focus:shadow-outline-purple dark:text-orange-100 dark:bg-orange-500" href="#">
            <div class="flex items-center">
                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                </svg>
                <span style="text-transform: uppercase;">Welcome Admin, <?= $_SESSION['loggedInAdmin']["AdminName"] ?></span>
            </div>
            <!-- <span>View more &RightArrow;</span> -->
        </a>
        <!-- Cards -->
        <div class="grid gap-6 mb-8 md:grid-cols-2 xl:grid-cols-4">
            <!-- Card -->
            <div class="flex items-center p-4 bg-white rounded-lg shadow-xs dark:bg-gray-800">
                <div class="p-3 mr-4 text-orange-500 bg-orange-100 rounded-full dark:text-orange-100 dark:bg-orange-500">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 bi bi-boxes" fill="currentColor" viewBox="0 0 18 18">
                        <path d="M7.752.066a.5.5 0 0 1 .496 0l3.75 2.143a.5.5 0 0 1 .252.434v3.995l3.498 2A.5.5 0 0 1 16 9.07v4.286a.5.5 0 0 1-.252.434l-3.75 2.143a.5.5 0 0 1-.496 0l-3.502-2-3.502 2.001a.5.5 0 0 1-.496 0l-3.75-2.143A.5.5 0 0 1 0 13.357V9.071a.5.5 0 0 1 .252-.434L3.75 6.638V2.643a.5.5 0 0 1 .252-.434L7.752.066ZM4.25 7.504 1.508 9.071l2.742 1.567 2.742-1.567L4.25 7.504ZM7.5 9.933l-2.75 1.571v3.134l2.75-1.571V9.933Zm1 3.134 2.75 1.571v-3.134L8.5 9.933v3.134Zm.508-3.996 2.742 1.567 2.742-1.567-2.742-1.567-2.742 1.567Zm2.242-2.433V3.504L8.5 5.076V8.21l2.75-1.572ZM7.5 8.21V5.076L4.75 3.504v3.134L7.5 8.21ZM5.258 2.643 8 4.21l2.742-1.567L8 1.076 5.258 2.643ZM15 9.933l-2.75 1.571v3.134L15 13.067V9.933ZM3.75 14.638v-3.134L1 9.933v3.134l2.75 1.571Z"></path>
                    </svg>
                </div>
                <div>
                    <p class="mb-2 text-sm font-medium text-gray-600 dark:text-gray-400">
                        Total packages
                    </p>
                    <p class="text-lg font-semibold text-gray-700 dark:text-gray-200">
                        <?= calculate($packages, "Total") ?>
                    </p>
                </div>
            </div>
            <!-- Card -->
            <div class="flex items-center p-4 bg-white rounded-lg shadow-xs dark:bg-gray-800">
                <div class="p-3 mr-4 text-green-500 bg-green-100 rounded-full dark:text-green-100 dark:bg-green-500">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div>
                    <p class="mb-2 text-sm font-medium text-gray-600 dark:text-gray-400">
                        Account balance
                    </p>
                    <p class="text-lg font-semibold text-gray-700 dark:text-gray-200">
                        Tsh <?= formatPrice(calculate($packages, "money")) ?>
                    </p>
                </div>
            </div>
            <!-- Card -->
            <div class="flex items-center p-4 bg-white rounded-lg shadow-xs dark:bg-gray-800">
                <div class="p-3 mr-4 text-blue-500 bg-blue-100 rounded-full dark:text-blue-100 dark:bg-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 bi bi-truck" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h9A1.5 1.5 0 0 1 12 3.5V5h1.02a1.5 1.5 0 0 1 1.17.563l1.481 1.85a1.5 1.5 0 0 1 .329.938V10.5a1.5 1.5 0 0 1-1.5 1.5H14a2 2 0 1 1-4 0H5a2 2 0 1 1-3.998-.085A1.5 1.5 0 0 1 0 10.5v-7zm1.294 7.456A1.999 1.999 0 0 1 4.732 11h5.536a2.01 2.01 0 0 1 .732-.732V3.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .294.456zM12 10a2 2 0 0 1 1.732 1h.768a.5.5 0 0 0 .5-.5V8.35a.5.5 0 0 0-.11-.312l-1.48-1.85A.5.5 0 0 0 13.02 6H12v4zm-9 1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm9 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"></path>
                    </svg>
                </div>
                <div>
                    <p class="mb-2 text-sm font-medium text-gray-600 dark:text-gray-400">
                        In transit
                    </p>
                    <p class="text-lg font-semibold text-gray-700 dark:text-gray-200">
                        <?= calculate($packages, "In Transit") ?>
                    </p>
                </div>
            </div>
            <!-- Card -->
            <div class="flex items-center p-4 bg-white rounded-lg shadow-xs dark:bg-gray-800">
                <div class="p-3 mr-4 text-teal-500 bg-teal-100 rounded-full dark:text-teal-100 dark:bg-teal-500">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8.515 1.019A7 7 0 0 0 8 1V0a8 8 0 0 1 .589.022l-.074.997zm2.004.45a7.003 7.003 0 0 0-.985-.299l.219-.976c.383.086.76.2 1.126.342l-.36.933zm1.37.71a7.01 7.01 0 0 0-.439-.27l.493-.87a8.025 8.025 0 0 1 .979.654l-.615.789a6.996 6.996 0 0 0-.418-.302zm1.834 1.79a6.99 6.99 0 0 0-.653-.796l.724-.69c.27.285.52.59.747.91l-.818.576zm.744 1.352a7.08 7.08 0 0 0-.214-.468l.893-.45a7.976 7.976 0 0 1 .45 1.088l-.95.313a7.023 7.023 0 0 0-.179-.483zm.53 2.507a6.991 6.991 0 0 0-.1-1.025l.985-.17c.067.386.106.778.116 1.17l-1 .025zm-.131 1.538c.033-.17.06-.339.081-.51l.993.123a7.957 7.957 0 0 1-.23 1.155l-.964-.267c.046-.165.086-.332.12-.501zm-.952 2.379c.184-.29.346-.594.486-.908l.914.405c-.16.36-.345.706-.555 1.038l-.845-.535zm-.964 1.205c.122-.122.239-.248.35-.378l.758.653a8.073 8.073 0 0 1-.401.432l-.707-.707z" />
                        <path d="M8 1a7 7 0 1 0 4.95 11.95l.707.707A8.001 8.001 0 1 1 8 0v1z" />
                        <path d="M7.5 3a.5.5 0 0 1 .5.5v5.21l3.248 1.856a.5.5 0 0 1-.496.868l-3.5-2A.5.5 0 0 1 7 9V3.5a.5.5 0 0 1 .5-.5z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div>
                    <p class="mb-2 text-sm font-medium text-gray-600 dark:text-gray-400">
                        Awaiting pickup
                    </p>
                    <p class="text-lg font-semibold text-gray-700 dark:text-gray-200">
                        <?= calculate($packages, "Delivered") ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Report Table -->
        <div class="w-full overflow-hidden rounded-lg shadow-xs">
            <div class="w-full overflow-x-auto">
                <br>
                <h2 class="text-lg font-semibold text-gray-700 dark:text-gray-200">Weekly Report</h2>
                <table class="w-full whitespace-no-wrap">
                    <thead>
                        <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                            <th class="px-4 py-3">Agent Name</th>
                            <th class="px-4 py-3">Region</th>
                            <th class="px-4 py-3">Received</th>
                            <th class="px-4 py-3">In transit</th>
                            <th class="px-4 py-3">Delivered</th>
                            <th class="px-4 py-3">Cleared</th>
                            <th class="px-4 py-3">Total</th>
                            <th class="px-4 py-3">Amount</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                        <?php
                        $sevenDaysData =  getDataFromPastSevenDays($packages);
                        $variable = generateAdminReport($packages);
                        // dd($variable);
                        $counter = 1;
                        foreach ($variable as $data) : ?>
                            <tr class="text-gray-700 dark:text-gray-400">
                                <td class="px-4 py-3 text-sm">
                                    <div class="flex items-center text-sm">
                                        <div class="relative hidden w-8 h-8 mr-3 rounded-full md:block">
                                            <?= $counter ?>
                                        </div>
                                        <div>
                                            <p class="font-semibold"><?= $data["AgentName"] ?></p>
                                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                                <?= $data["AgentPhone"] ?>
                                            </p>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    <?= $data["Region"] ?>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    <?= $data["Received"] ?>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    <?= $data["In transit"] ?>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    <?= $data["Delivered"] ?>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    <?= $data["Cleared"] ?>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    <?= $data["Total packages"] ?>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    <?= formatPrice($data["Total shipping fee"]) ?>
                                </td>
                            </tr>
                        <?php
                            $counter++;
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- PackagesTable -->
        <div class="w-full overflow-hidden rounded-lg shadow-xs">
            <div class="w-full overflow-x-auto">
                <br>
                <h2 class="text-lg font-semibold text-gray-700 dark:text-gray-200">Packages List</h2>
                <form action="" method="POST">
                    <table class="w-full whitespace-no-wrap">
                        <thead>
                            <tr class="text-gray-700 dark:text-gray-400">
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <label for="select-all">
                                        <input type="button" id="select-all" onclick='selects()' value="" class="w-[1.125rem] h-[1.125rem] text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" />
                                        Select All
                                    </label>
                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <label for="deselect-all">
                                        <input type="button" id="deselect-all" value="" onclick='deSelect()' class="w-[1.125rem] h-[1.125rem] text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" />
                                        Unselect All
                                    </label>
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">

                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <span class="flex">
                                        <!-- Open the modal using ID.showModal() method -->
                                        <dialog id="my_modal_edit" class="modal rounded-md bg-green-50 dark:bg-gray-100 ">
                                            <div class="modal-box">
                                                <h3 class="font-bold text-lg">Edit Model</h3>
                                                <p class="py-4">Press ESC key or click the button below to close</p>
                                                <div class="modal-action">
                                                    <!-- if there is a button in form, it will close the modal -->
                                                    <div class="text-gray-700">
                                                        <h3>Update Status for selected items</h3>
                                                        <select name="status" class="block w-full mt-1 text-sm  form-select focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:focus:shadow-outline-gray">
                                                            <option id="fuggy-package-id"></option>
                                                            <option value="Received">Received</option>
                                                            <option value="In Transit">In Transit</option>
                                                            <option value="Delivered">Delivered</option>
                                                        </select>
                                                    </div>
                                                    <br>
                                                    <div class="flex justify-between">
                                                        <button type="submit" name="admin_submit_action" value="Edit" class="btn py-1 px-3 text-green-500 bg-green-100 rounded-sm border-2 border-gray-600 dark:text-green-100 dark:bg-green-500 font-semibold focus:outline-none">Submit</button>
                                                        <form method="dialog">
                                                            <button class="btn">Close</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </dialog>
                                        <button type="button" onclick="my_modal_edit.showModal()" class="mr-3 focus:outline-none focus:border-transparent">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z" />
                                            </svg>
                                        </button>
                                        Edit
                                    </span>
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">

                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <span class="flex">
                                        <!-- Open the modal using ID.showModal() method -->
                                        <dialog id="my_modal_delete" class="modal rounded-md bg-green-50 dark:bg-gray-100 ">
                                            <div class="modal-box">
                                                <h3 class="font-bold text-lg">Delete Packages</h3>

                                                <p class="py-4">Are you sure you want to delete selected packages?</p>
                                                <div class="modal-action">
                                                    <!-- if there is a button in form, it will close the modal -->
                                                    <div class="flex justify-between">
                                                        <button type="submit" name="admin_submit_action" value="Delete" class="btn py-1 px-3 text-orange-500 bg-orange-100 rounded-sm border border-gray-600 dark:text-orange-100 dark:bg-orange-500 font-semibold focus:outline-none">Delete</button>
                                                        <form method="dialog">
                                                            <button class="btn">Close</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </dialog>
                                        <button type="button" onclick="my_modal_delete.showModal()" class="btn mr-3 focus:outline-none focus:border-transparent">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                            </svg>
                                        </button>
                                        Delete
                                    </span>
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">

                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <span class="flex">
                                        <dialog id="my_modal_export" class="modal rounded-md bg-green-50 dark:bg-gray-100 ">
                                            <div class="modal-box">
                                                <h3 class="font-bold text-lg">Export Model</h3>
                                                <p class="py-4">Press ESC key or click the button below to close</p>
                                                <div class="modal-action">
                                                    <!-- <form method="dialog"> -->
                                                    <!-- if there is a button in form, it will close the modal -->
                                                    <!-- <button class="btn">Close</button> -->
                                                    <!-- </form> -->
                                                    <!-- onclick="my_modal_export.showModal()"  -->
                                                </div>
                                            </div>
                                        </dialog>
                                        <button type="submit" name="admin_submit_action" value="Export" class="mr-3 focus:outline-none focus:border-transparent">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-spreadsheet" viewBox="0 0 16 16">
                                                <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zM9.5 3A1.5 1.5 0 0 0 11 4.5h2V9H3V2a1 1 0 0 1 1-1h5.5v2zM3 12v-2h2v2H3zm0 1h2v2H4a1 1 0 0 1-1-1v-1zm3 2v-2h3v2H6zm4 0v-2h3v1a1 1 0 0 1-1 1h-2zm3-3h-3v-2h3v2zm-7 0v-2h3v2H6z" />
                                            </svg>
                                        </button>
                                        Export
                                    </span>
                                </td>
                            </tr>
                            <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                                <th class="px-4 py-3">Package Info</th>
                                <th class="px-4 py-3">Payment</th>
                                <th class="px-4 py-3">Location</th>
                                <th class="px-4 py-3">Destination</th>
                                <th class="px-4 py-3">Sender</th>
                                <th class="px-4 py-3">Reciever</th>
                                <th class="px-4 py-3">Date</th>
                                <th class="px-4 py-3">Status</th>
                                <th class="px-4 py-3">Action</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                            <!-- render output -->
                            <?= renderFilteredPackages($packages, "Cleared") ?>
                        </tbody>
                    </table>
                </form>
            </div>
            <div class="grid px-4 py-3 text-xs font-semibold tracking-wide text-gray-500 uppercase border-t dark:border-gray-700 bg-gray-50 sm:grid-cols-9 dark:text-gray-400 dark:bg-gray-800">
                <span class="flex items-center col-span-3">
                    Showing 21-30 of 100
                </span>
                <span class="col-span-2"></span>
                <!-- Pagination -->
                <span class="flex col-span-4 mt-2 sm:mt-auto sm:justify-end">
                    <nav aria-label="Table navigation">
                        <ul class="inline-flex items-center">
                            <li>
                                <button class="px-3 py-1 rounded-md rounded-l-lg focus:outline-none focus:shadow-outline-purple" aria-label="Previous">
                                    <svg aria-hidden="true" class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" fill-rule="evenodd"></path>
                                    </svg>
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 text-white transition-colors duration-150 bg-purple-600 border border-r-0 border-purple-600 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    1
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    2
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    3
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    4
                                </button>
                            </li>
                            <li>
                                <span class="px-3 py-1">...</span>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    8
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md focus:outline-none focus:shadow-outline-purple">
                                    9
                                </button>
                            </li>
                            <li>
                                <button class="px-3 py-1 rounded-md rounded-r-lg focus:outline-none focus:shadow-outline-purple" aria-label="Next">
                                    <svg class="w-4 h-4 fill-current" aria-hidden="true" viewBox="0 0 20 20">
                                        <path d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" fill-rule="evenodd"></path>
                                    </svg>
                                </button>
                            </li>
                        </ul>
                    </nav>
                </span>
            </div>
        </div><br>
    </div>
</main>