<main class="h-full overflow-y-auto">
    <div class="container px-6 mx-auto grid">
        <h2 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
            Agent Performance
        </h2>
        <div class="w-full overflow-hidden rounded-lg shadow-xs">
            <div class="w-full overflow-x-auto">
                <form action="" method="GET">
                    <table class="w-full whitespace-no-wrap">
                        <thead>
                            <tr class="text-gray-700 dark:text-gray-400 bg-orange-100 dark:bg-gray-800">
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <label for="sort">Sort By:</label>
                                    <select id="sort" name="sort" onchange="this.form.submit()" class="text-sm bg-gray-50 dark:bg-gray-900">
                                        <option value="">Choose Here</option>
                                        <option value="agentName">Alphabetically</option>
                                        <option value="totalPackages"> No of Packages</option>
                                        <option value="receivedCount">Received</option>
                                        <option value="inTransitCount">In Transit</option>
                                        <option value="deliveredCount">Delivered</option>
                                        <option value="clearedCount">Cleared</option>
                                        <option value="totalCost">Ship Fee</option>
                                    </select>
                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">
                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                </td>
                                <td class=" text-gray-700 dark:text-gray-400 text-sm">
                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                </td>
                                <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                    <button type="button" class="bg-red-600 px-3 py-1 text-white border border-transparent rounded-md" onclick="clearDateParameter()">Clear</button>
                                </td>
                            </tr>
                            <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b bg-orange-100 dark:border-gray-700 dark:text-gray-400 dark:bg-gray-800">
                                <th class="px-4 py-3">Agent</th>
                                <th class="px-4 py-3">Packages</th>
                                <th class="px-4 py-3">Received</th>
                                <th class="px-4 py-3">In Transit</th>
                                <th class="px-2 py-3">Delivered</th>
                                <th class="px-2 py-3">Cleared</th>
                                <th class="px-2 py-3">Amount</th>
                                <th class="px-2 py-3">Action</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                            <?php
                            $agentReportData = agentReport($agents, $packages);
                            sortAgentReport($agentReportData, $_GET['sort']) ?>
                        </tbody>
                    </table>
                </form>
            </div>
        </div>
    </div>
</main>
<script>
    function clearDateParameter() {
        var currentUrl = window.location.href;

        // Remove the 'startDate' parameter from the URL then remove the updatedUrl also
        var updatedUrl = removeURLParameter(currentUrl, 'sort');

        // Updates the URL without reloading the page
        history.pushState({}, document.title, updatedUrl);

        // Uncomment to reload the page if neccessary 
        window.location.reload();
    }

    function removeURLParameter(url, parameter) {
        var urlParts = url.split('?');
        if (urlParts.length >= 2) {
            var prefix = encodeURIComponent(parameter) + '=';
            var params = urlParts[1].split(/[&;]/g);

            for (var i = params.length; i-- > 0;) {
                if (params[i].lastIndexOf(prefix, 0) !== -1) {
                    params.splice(i, 1);
                }
            }

            // Reconstructed
            url = urlParts[0] + (params.length > 0 ? '?' + params.join('&') : '');
        }

        return url;
    }
</script>