<main class="h-full overflow-y-auto">
    <div class="container px-6 mx-auto grid">
        <div class="custom_devider">
            <div class="custom_devider_header">
                <h2 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
                    Registered Agents
                </h2>
            </div>
            <div class="custom_devider_button">
                <div class="px-6 my-6">
                    <a class="flex items-center justify-between w-full px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple" href="<?= resolvePath('admin/app/views/createagent.php') ?>">
                        Add Agent
                        <span class="ml-2" aria-hidden="true">+</span>
                    </a>
                </div>
            </div>
        </div>

        <div class="w-full overflow-hidden rounded-lg shadow-xs">
            <div class="w-full overflow-x-auto">
                <table class="w-full whitespace-no-wrap">
                    <thead>
                        <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                            <th class="px-4 py-3">Agent</th>
                            <th class="px-4 py-3">Phone</th>
                            <th class="px-4 py-3">Email</th>
                            <th class="px-4 py-3">Region</th>
                            <th class="px-2 py-3">Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                        <?= returnAgents($agents) ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- Track Payments -->
        <h2 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
            Track Cash Payments
        </h2>
        <div class="w-full overflow-hidden rounded-lg shadow-xs">
            <div class="w-full overflow-x-auto">
                <table class="w-full whitespace-no-wrap">
                    <thead>
                        <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800">
                            <th class="px-4 py-3">Agent</th>
                            <th class="px-4 py-3">Cash Received</th>
                            <th class="px-4 py-3">Amount Paid</th>
                            <th class="px-4 py-3">Remaining</th>
                            <th class="px-4 py-3">New Payment</th>
                            <th class="px-2 py-3">Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                        <?=  trackCashPay($trackPay)?>
                    </tbody>
                </table>
            </div>
        </div>
        <br>
    </div>
</main>