<?php include("framework/init.php"); ?>

<body>
    <div class="flex h-screen bg-gray-50 dark:bg-gray-900" :class="{ 'overflow-hidden': isSideMenuOpen }">
        <?php include("framework/nav.php"); ?>

        <div class="flex flex-col flex-1 w-full">
            <?php include("framework/header.php"); ?>

            <main class="h-full overflow-y-auto">
                <div class="container px-6 mx-auto grid">
                    <h1 class="mb-4 text-xl font-semibold text-gray-700 dark:text-gray-200">
                        Create Agent Account
                    </h1>
                    <div class="px-4 py-3 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
                        <form method="POST">
                            <label class="block text-sm">
                                <span class="text-gray-700 dark:text-gray-400">Agent Name</span>
                                <input name="agentName" type="text" class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="e.g. Jane Doe" required />
                            </label>
                            <label class="block text-sm">
                                <span class="text-gray-700 dark:text-gray-400">Email</span>
                                <input name="agentEmail" type="email" class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="e.g. example@gmail.com" required />
                            </label>
                            <label class="block text-sm">
                                <span class="text-gray-700 dark:text-gray-400">Phone No</span>
                                <input name="agentPhone" type="tel" class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="e.g. 255655626482" required />
                            </label>
                            <label class="block mt-4 text-sm">
                                <span class="text-gray-700 dark:text-gray-400">Region</span>
                                <input name="agentRegion" type="text" text class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="E.g Mwanza" required />
                            </label>
                            <label class="block mt-4 text-sm">
                                <span class="text-gray-700 dark:text-gray-400">Password</span>
                                <input id="password" name="agentPass" type="password" text class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="************" required />
                            </label>
                            <p id="password-strength"></p>
                            <label class="block mt-4 text-sm">
                                <span class="text-gray-700 dark:text-gray-400">Confirm Password</span>
                                <input name="agentConfirmPass" type="password" text class="block w-full mt-1 text-sm dark:border-gray-600 dark:bg-gray-700 focus:border-purple-400 focus:outline-none focus:shadow-outline-purple dark:text-gray-300 dark:focus:shadow-outline-gray form-input" placeholder="************" required />
                            </label>
                            <button type="submit" id="submit-button" name="addAgent" class="block w-full px-4 py-2 mt-4 text-sm font-medium leading-5 text-center text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple" href="./login.html">
                                Create account
                            </button>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>


<script>
    // Get references to DOM elements
    const passwordInput = document.getElementById('password');
    const strengthIndicator = document.getElementById('password-strength');
    const submitButton = document.getElementById('submit-button');

    // Define password strength criteria
    const minLength = 8;
    const maxLength = 16; // You can adjust the maximum length as needed
    const uppercaseRegex = /[A-Z]/;
    const lowercaseRegex = /[a-z]/;
    const numberRegex = /[0-9]/;
    const specialCharRegex = /[!@#$%^&*()_+\-=[\]{};':"\\|,.<>/?]/;

    // Function to check password strength
    function checkPasswordStrength(password) {
        const isLengthValid = password.length >= minLength && password.length <= maxLength;
        const hasUppercase = uppercaseRegex.test(password);
        const hasLowercase = lowercaseRegex.test(password);
        const hasNumber = numberRegex.test(password);
        const hasSpecialChar = specialCharRegex.test(password);

        let message = '';

        if (!isLengthValid) {
            message = `Password should be ${minLength} to ${maxLength} characters long.`;
        } else if (!(hasUppercase && hasLowercase && hasNumber && hasSpecialChar)) {
            message = `Password should contain a mix of uppercase letters, lowercase letters, numbers, and special characters.`;
        }

        return message === '' ? 'Strong' : message;
    }

    // Function to update UI based on password strength
    function updateStrengthIndicator(password) {
        const strengthMessage = checkPasswordStrength(password);

        if (strengthMessage === 'Strong') {
            strengthIndicator.textContent = 'Strong';
            strengthIndicator.style.color = 'green';
            submitButton.disabled = false; // Enable the submit button for strong passwords
        } else {
            strengthIndicator.textContent = strengthMessage;
            strengthIndicator.style.color = 'red';
            submitButton.disabled = true; // Disable the submit button for weak passwords
        }
    }

    // Add input event listener to password input
    passwordInput.addEventListener('input', function() {
        const password = passwordInput.value;
        updateStrengthIndicator(password);
    });
</script>
