<?php include("framework/init.php"); ?>
<?php
$workingArr = "Error: No Agent Identity passed in the URL";
if (isset($_GET['meta'])) {
    $num = $_GET['meta'];
    $workingArr = array_values(returnAgetPackages($packages, $num));
    foreach ($agents as $agent) {
        if ($num == $agent["Id"]) {
            foreach ($workingArr as &$package) {
                if ($package["RecordingAgentID"] == $num) {
                    $package['OldestDate'] =  convertTimeFormatBeta($agent["registeredDate"]);
                    $package['ReceiverContactInfo'] = formatTanzaniaPhoneNumber($package['ReceiverContactInfo']);
                }
            }
        }
    }
    $_SESSION['admin-meta-data'] = $workingArr;
}

$workingArr = $_SESSION['admin-meta-data'];
// dd( $workingArr);

/**
 * Sorting algorithm implemented directly in views for SoC purposes
 * 
 * STEP 1: Sort the given array by date @param currentDate
 * STEP 2: Apply the date argument and cut-off to the latest packages @param cutoffDate
 * STEP 3: Print out the updated array
 * STEP 4: Listen to the user inputs and make step 1 and step 2 dynamic (filtering options) and  (custom cut-off date) 
 */

// $currentSort = "Choose Here";

$currentDate = date('Y-m-d');
$cutoffDate = date('Y-m-d', strtotime('-30 days', strtotime($currentDate)));
$dateValue = $cutoffDate;
$minForAgent = $workingArr[0]['OldestDate'];

// ON PROGRESS
// if (isset($_GET['rankBy'])) {
//     $sort = $_GET['rankBy'];
//     switch ($sort) {
//         case 'latest':
//         case 'cost':
//         case 'received':
//         case 'inTransit':
//         case 'delivered':
//         case 'cleared':
//     }
// }


if (isset($_GET['startDate'])) {
    $dateValue = $_GET['startDate'];
    $startDate = $_GET['startDate'];
    $toDisplayArr = filterworkingArrByDate($workingArr, $startDate);
} else {
    $toDisplayArr = filterworkingArrByDate($workingArr, $cutoffDate);
}

// handling sending msg 
if (isset($_POST['sendReceiverSMS'])) {
    $receiverName = $_POST['receiverName_msg'];
    $receiverPhone = $_POST['receiverPhone_msg'];
    $message = $_POST['message_area'];
// handling sending msg 
    $contact = formatTanzaniaPhoneNumber255($receiverPhone);
    sendSMSAPI($contact, $message);
}
?>

<body>
    <div class="flex h-screen bg-gray-50 dark:bg-gray-900" :class="{ 'overflow-hidden': isSideMenuOpen }">
        <?php include("framework/nav.php"); ?>

        <div class="flex flex-col flex-1 w-full">
            <?php include("framework/header.php"); ?>

            <!-- Main body -->
            <main class="h-full overflow-y-auto">
                <div class="container px-6 mx-auto grid">
                    <h2 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
                        Agent Report: <span class="text-blue-500"><?= $workingArr[0]["AgentName"] ?> </span>
                    </h2>
                    <a href="javascript:history.back()" class="underline text-blue-500">
                        << Go Back</a>
                            <div class="w-full overflow-hidden rounded-lg shadow-xs">
                                <div class="w-full overflow-x-auto">
                                    <form action="" method="GET" class="inline-block">
                                        <table class="w-full whitespace-no-wrap">
                                            <thead>
                                                <tr class="text-xs font-semibold tracking-wide text-left text-gray-700 dark:text-gray-400 bg-orange-100 dark:bg-gray-800">
                                                    <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                                        <label for="sort">Rank By:</label>
                                                        <select id="sort" name="rankBy" onchange="this.form.submit()" class="text-sm bg-gray-50 dark:bg-gray-900">
                                                            <option value="">Choose Here</option>
                                                            <option value="latest"> Newly added</option>
                                                            <option value="cost">Ship Fee</option>
                                                            <option value="received">Received</option>
                                                            <option value="inTransit">In Transit</option>
                                                            <option value="delivered">Delivered</option>
                                                            <option value="cleared">Cleared</option>
                                                        </select>
                                                    </td>
                                                    <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                                    </td>
                                                    <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                                    </td>
                                                    <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                                    </td>
                                                    <td class=" text-gray-700 dark:text-gray-400 text-sm">
                                                        <label for="date">
                                                            Show Entries from:
                                                            <input type="date" onchange="this.form.submit()" value=<?= $dateValue ?> name="startDate" id="date" min=<?= $minForAgent ?> max=<?= $currentDate ?> class="text-sm text-gray-700 placeholder-gray-600 bg-gray-100 dark:placeholder-gray-500 dark:text-gray-200 dark:bg-gray-700">
                                                        </label>
                                                    </td>
                                                    <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                                    </td>
                                                    <td class="px-4 py-3 text-gray-700 dark:text-gray-400 text-sm">
                                                        <button type="button" class="bg-red-600 px-3 py-1 text-white border border-transparent rounded-md" onclick="clearDateParameter()">Clear</button>
                                                    </td>
                                                </tr>
                                                <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase border-b dark:border-gray-700  dark:text-gray-400 dark:bg-gray-800 bg-orange-100">
                                                    <th class="px-4 py-3">Package Name</th>
                                                    <th class="px-4 py-3">From</th>
                                                    <th class="px-4 py-3">To</th>
                                                    <th class="px-4 py-3">Receiver</th>
                                                    <th class="px-4 py-3">Status</th>
                                                    <th class="px-4 py-3">Ship Fee</th>
                                                    <th class="px-4 py-3">Date</th>
                                                </tr>
                                            </thead>
                                            <tbody class="bg-white divide-y dark:divide-gray-700 dark:bg-gray-800">
                                                <!-- data here -->
                                                <?php foreach ($toDisplayArr as $item) : ?>
                                                    <tr class="text-gray-700 dark:text-gray-400">
                                                        <td class="px-4 py-3">
                                                            <div class="flex items-center text-sm">
                                                                <div>
                                                                    <p class="font-semibold"><?= $item["PackageName"] ?></p>
                                                                    <p class="text-xs text-gray-600 dark:text-gray-400">
                                                                        ID #<?= $item["PackageID"] ?>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="px-4 py-3"><?= $item["DepartureLocation"] ?></td>
                                                        <td class="px-4 py-3"><?= $item["Destination"] ?></td>
                                                        <td class="px-4 py-3">
                                                            <div class="flex items-center text-sm">
                                                                <div>
                                                                    <p><?= $item["ReceiverName"] ?></p>
                                                                    <button type="button" title="Send Message" @click="openReceiverMsgModel(<?php echo htmlspecialchars(json_encode($item), ENT_QUOTES, 'UTF-8'); ?>)" class="flex items-center justify-between px-3 py-1 text-sm font-medium text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-md active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">
                                                                        <span>Message</span>
                                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class=" w-4 h-4 ml-2 -mr-1 flex items-center" viewBox="0 0 20 20" aria-hidden="true">
                                                                            <path d="M15.854.146a.5.5 0 0 1 .11.54l-5.819 14.547a.75.75 0 0 1-1.329.124l-3.178-4.995L.643 7.184a.75.75 0 0 1 .124-1.33L15.314.037a.5.5 0 0 1 .54.11ZM6.636 10.07l2.761 4.338L14.13 2.576 6.636 10.07Zm6.787-8.201L1.591 6.602l4.339 2.76 7.494-7.493Z" />
                                                                        </svg>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <!-- <td class="px-4 py-3">< ?=$item["ReceiverContactInfo"] ?></td> -->
                                                        <td class="px-4 py-3"><?= $item["Status"] ?></td>
                                                        <td class="px-4 py-3"><?= $item["ShippingFee"] ?></td>
                                                        <td class="px-4 py-3"><?= $item["date"] ?></td>
                                                    </tr>
                                                <?php endforeach;
                                                if(!$toDisplayArr){
                                                    echo '
                                                    <tr class="text-gray-700 dark:text-gray-400">
                                                   <td class="py-3"></td>
                                                   <td class="py-3"></td>
                                                   <td class="py-3"></td>
                                                   <td class="py-3">No packages during selected time period</td>
                                                   <td class="py-3"></td>
                                                   <td class="py-3"></td>
                                                   <td class="py-3"></td>
                                                    </tr>';
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </form>
                                    <!-- Send message to receiver modal -->
                                    <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 z-30 flex items-end bg-black bg-opacity-50 sm:items-center sm:justify-center">
                                        <div x-show="isModalOpen" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0 transform translate-y-1/2" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0  transform translate-y-1/2" @click.away="closeModal" @keydown.escape="closeModal" class="border border-gray-600 rounded-md dark:border-gray-700 bg-gray-50 dark:text-gray-400 dark:bg-gray-800 sm:rounded-lg sm:m-4 sm:max-w-xl" role="dialog" id="modal">
                                            <div class="w-auto bg-white dark:bg-gray-800 rounded-md p-3">
                                                <h2 class="font-semibold text-lg mb-4">Message: <span class="text-blue-500" id="receiverName-msg"></span></h2>
                                                <form action="" method="POST">
                                                    <label class="text-base font-semiblold block py-2" for="receiverName_msg">Recipient Name <input class="py-1 dark:bg-gray-800 bg-gray-50 text-gray-700 dark:text-gray-200 focus:outline-none form-input w-full block" type="text" name="receiverName_msg" id="receiverName_msg" value=""></label>
                                                    <label class="text-base font-semiblold block py-2" for="receiverPhone_msg">Recipient Phone <input class="py-1 dark:bg-gray-800 bg-gray-50 text-gray-700 dark:text-gray-200 focus:outline-none form-input w-full block" type="text" name="receiverPhone_msg" id="receiverPhone_msg" value=""></label>
                                                    <label class="text-base font-semiblold block py-2" for="message_area">Message <textarea class="py-1 dark:bg-gray-800 bg-gray-50 text-gray-700 dark:text-gray-200 focus:outline-none form-textarea w-full block" rows="3" name="message_area" id="message_area"></textarea></label>
                                                    <div class="flex flex-col items-center justify-end px-6 py-3 -mx-6 -mb-4 space-y-4 sm:space-y-0 sm:space-x-6 sm:flex-row">
                                                        <button type="button" @click="closeModal" class="px-5 py-3 text-sm font-medium leading-5 dark:text-cool-gray-50text-white text-gray-700 transition-colors duration-150 border border-gray-300 rounded-lg dark:text-gray-400 sm:px-4 sm:py-2 sm:w-auto active:bg-transparent hover:border-gray-500 focus:border-gray-500 active:text-gray-500 focus:outline-none focus:shadow-outline-gray">
                                                            Cancel
                                                        </button>
                                                        <input class="px-5 py-3 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg sm:w-auto sm:px-4 sm:py-2 active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple" type="submit" value="Send" name="sendReceiverSMS" id="sendReceiverSMS">
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                </div>
            </main>
            <!-- End of main body -->

        </div>
    </div>
</body>
<script>
    function clearDateParameter() {
        var currentUrl = window.location.href;

        // Remove the 'startDate' parameter from the URL then remove the updatedUrl also
        var updatedUrl = removeURLParameter(currentUrl, 'startDate');
        updatedUrl = removeURLParameter(updatedUrl, 'rankBy');

        // Updates the URL without reloading the page
        history.pushState({}, document.title, updatedUrl);

        // Uncomment to reload the page if neccessary 
        window.location.reload();
    }

    function removeURLParameter(url, parameter) {
        var urlParts = url.split('?');
        if (urlParts.length >= 2) {
            var prefix = encodeURIComponent(parameter) + '=';
            var params = urlParts[1].split(/[&;]/g);

            for (var i = params.length; i-- > 0;) {
                if (params[i].lastIndexOf(prefix, 0) !== -1) {
                    params.splice(i, 1);
                }
            }

            // Reconstructed
            url = urlParts[0] + (params.length > 0 ? '?' + params.join('&') : '');
        }

        return url;
    }
</script>