# Web Bluetooth Printer

Available at https://webbluetoothcg.github.io/demos/bluetooth-printer/

<img src="https://raw.githubusercontent.com/webbluetoothcg/demos/gh-pages/bluetooth-printer/printer.jpg">

This web app demonstrates the use of the Web Bluetooth API for printing to a BLE printer.

## Dependencies
* Bluetooth printer: http://www.amazon.com/Version-AGPtek%C2%AE-Portable-Bluetooth-Wireless/dp/B00XL3DY2E
* ChromeOS 48 with Web Bluetooth API enabled: https://developers.google.com/web/updates/2015/07/interact-with-ble-devices-on-the-web?hl=en
* Bower: http://bower.io/

## Setup Instructions
* Run the following command to install the packages listed in bower.json to the bower_components folder: bower install
* Host the app on your web server.
* Confirm the Web Bluetooth implementation status: https://github.com/WebBluetoothCG/web-bluetooth/blob/gh-pages/implementation-status.md
* Load the web app in a Chrome browser.
* Switch on the printer and press the power button until the power LED is blue.
* Enter a message on the web app.
* Click on the "Print" button to print the image and message.

## References and How to report bugs
* Web Bluetooth API: https://webbluetoothcg.github.io/web-bluetooth/
* If you find any issues, please open a bug here on GitHub

## How to make contributions?
Please read and follow the steps in the CONTRIBUTING.md

## License
See LICENSE

## Google+
Web Bluetooth Community on Google+: https://plus.google.com/communities/108953318610326025178
